Include([[Data/levels/include/level_utils.lua]])
Include([[Data/levels/include/random_achieve.lua]])

Level =
{
	MapSkinFilename = LevelUtils.PickRandomChoice(LevelUtils.GetAllSkinFilenames()),
	MapGenScript = function ()
	
		MapGeometry:Randomize(60000)
		MapEntities:SetParameters(LevelUtils.MapGenDefaults)
		MapEntities:GenerateLocations()
	
		--Capture point placement
		for i=1, 4 do
			MapEntities:PlaceCapPoint(false, -1, 2, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		end

		for i=1, 4 do
			MapEntities:PlaceCapPoint(false, -1, 3, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		end
		
		MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
		GameWorld:AddMarines(homeBase:GetPos(), GameWorld:GetStartingTeamSize())
		GameWorld:ResetCamera(homeBase:GetPos())
		--GameWorld:FocusCameraOn(homeBase)
		
		--Alien support structs
		MapEntities:PlaceEnemyStuctures(15.0, 5.0);
		
		--Place crates
		for i=1, 3 do
			MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
		end
		
		for i=1, 3 do
			MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
		end		
	end,
	
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 30.0,
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier    = 1.0,
		
		DefaultHiveTowerCount = 10,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 8,
		Default = [[inactive]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		    [[ZU_HARDPOINT_MIMIC]],
		    [[ZU_HARDPOINT_GUARDS]],
			[[ZU_REFLECTION]],
		},
		Randomize = true
	},
	MarineUpgrades = 
	{
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
	end
}


------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		CaptureAllObjective:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()


------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
			
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()

------------------------------------------------------------------------------- Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_GAME_OVER]]},
	function (self, p_type, p_entId, p_pos, p_other)
        if p_other == "win" then
		    SteamAchievements:SetAchievement("BEAT_RUINS")
		end	
	end):Enable()
